/*******************************************************************************
 *
 *      A U D I O   R E C O R D E R    U I  D R I V E R
 *
 *      Copyright A Levido 2013 - All Rights Reserved
 *
 ******************************************************************************/
#ifndef UIDRIVER_H
#define UIDRIVER_H
#include "genericTypeDefs.h"

/* Define Size & type of LCD */
#define LCD_WIDTH                128    // Width in Pixels
#define LCD_HEIGHT               64     // Height in Pixels
//#define LCD_REVERSE              1      // 1 for transmissive. 0 for reflective
//#define LCD_ORIENTATION          1      // 1 for 6 o'clock, 0 for 12 o'clock

/* API ************************************************************************/
/** Initialise User Interface */
void cdcInit(void);

void cdcShutdown();


void cdcWakeup();

/** Reset Codec
 *  Resets codec and reloads all data from the shadow - does not change any
 *  setting */
void cdcRestart(void);

INT8* cdcIncLineLevel(void);

/** Decrement Line Level
 *  Decrements line level by one step
 *  @returns    pointer to a string containing the line level
 */
INT8* cdcDecLineLevel(void);

/** Set Microphone boost level
 *  @param bst  boost state (0 = 0 dB, 1 = +20 dB
 *  @returns    pointer to a string containing the boost level
 */
INT8* cdcSetMicBoost(UINT32 bst);

/** Get Microphone boost level
 *  @returns    boost state (0 = 0 dB, 1 = +20 dB
 */
UINT32 cdcGetMicBoost(void);
/** Set Input Mute Level
 *  @param mute mute state (0 = no mute, 1 = muted)
 */
void cdcSetInputMute(UINT32 mute);

/** Increment Volume Level
 *  Increments level by one step
 *  @returns    pointer to a string containing the volume level
 */
INT8* cdcIncVolume(void);

/** Decrement Volume Level
 *  Decrements level by one step
 *  @returns    pointer to a string containing the volume level
 */
INT8* cdcDecVolume(void);

/** Set Output Mute State
 *  @param mute mute state (0 = no mute, 1 = muted)
 */
void cdcSetOutputMute(UINT32 mute);

/** Set DAC Mute State
 *  @param mute mute state (0 = no mute, 1 = muted)
 */
void cdcSetDACMute(UINT32 mute);

/** Set Bit Rate
 *  Sets bit rate: 0 = 8K, 16K, 22K05, 24K, 32K, 44K1, 48K, 88K2, 96K
 *  @param     rate index
 *  @returns   pointer to a string containing the bit rate
 */
INT8* cdcSetRate(UINT32 r);

/** Set Bit depth
 *  @param 1s32  0 = 16 bits, 1 = 32 bits
 */
void cdcSetBitDepth(UINT32 is32);

int cdcGetSampleRate();

/** Get Bit Rate Stringf
 *  @param     rate index
 *  @returns   pointer to a string containing the bit rate
 */
INT8* cdcGetRateString(UINT32 r);
/** Set Input source
 *  @param mic  0 = line, 1 = mic
 */
void cdcSetSource(UINT32 mic);

/** Get Input source
 *  @returns source  0 = line, 1 = mic
 */
UINT32 cdcGetSource(void);
/** Swap L & R channels
 *  @param swap  0 = no swap, 1 = swap
 */
void cdcSetLRSwap(UINT32 swap);

/** Set de-emphasis
 *  @param demph  0 = none, 1 = 32 kHz, 2 = 44.1 KHz, 3 = 48 KHz
 */
void cdcSetDeemphasis(UINT32 demph);

/** Set Monitor Mode
 * @param monitor   0 = none, 1 = monitor */
void cdcSetMonitor(UINT32 monitor);

#define TIME_SEPARATOR      ':'
#define DATE_SEPARATOR      '-'

 /** Clock Driver Initialisation
  * Enables interrupt for the one second tick event */
void clkInitialise(void);

/** Shut Down Clock Interrupts */
void clkShutdown();

/** Wake up clock interrupts */
void clcWakeup();

/** Get time as a string
 *  @param buffer   - pointer to buffer 9 chars or longer  */
INT8* clkGetTimeString(INT8* buffer);

/** Get date as a string
 *  @param buffer   - pointer to buffer 11 chars or longer */
INT8* clkGetDateString(INT8* buffer);

/** Get time and date as a FAT packed 32-bit word
 *  @returns   - FAT formatted time/date stamp */
DWORD get_fattime(void);

/** Append timestamp
 *  Appends a timestamp YYMMDD-hhmmss to the buffer. The buffer must have
 *  14 extra spaces.
 *  @param buff     pointer to buffer containing root name */
void clkAppendTimestamp(INT8* buff);

#endif
